<?php
/**
 * Bizmart — Arabic translation dictionary.
 *
 * @package Bizmart
 * @license GPL-2.0-or-later
 */

if ( ! defined( 'ABSPATH' ) ) { exit; }

if (!function_exists('bizmart_i18n_ar')) {
    function bizmart_i18n_ar(string $en): string {
        static $map = null;
        if ($map === null) {
            $map = bizmart_i18n_ar_map();
        }
        return $map[$en] ?? $en;
    }
}

if (!function_exists('bizmart_i18n_ar_map')) {
    function bizmart_i18n_ar_map(): array {
        // English-keyed dictionary used for Arabic admin UI mode.
        // Keep keys stable (English-first), values are Arabic.
        return [
            'Accounting' => 'المحاسبة',
            'Action' => 'إجراء',
            'Actions' => 'الإجراءات',
            'Active' => 'نشط',
            'Add' => 'إضافة',
            'Add a Payment' => 'إضافة دفعة',
            'Add a new row' => 'إضافة سطر جديد',
            'Add a tag, press Enter' => 'أضف وسمًا ثم اضغط Enter',
            'Add a value, press Enter' => 'أضف قيمة ثم اضغط Enter',
            'Add all values' => 'إضافة كل القيم',
            'Add another attribute' => 'إضافة سمة أخرى',
            'Add attribute' => 'إضافة سمة',
            'Add date (YYMMDD)' => 'إضافة التاريخ (YYMMDD)',
            'Add expense' => 'إضافة مصروف',
            'Add files' => 'إضافة ملفات',
            'Add manually' => 'إضافة يدويًا',
            'Add multiple images' => 'إضافة عدة صور',
            'Add Payment' => 'إضافة دفعة',
            'Add prefix (INV-)' => 'إضافة بادئة (INV-)',
            'Add Row' => 'إضافة سطر',
            'Add sequence' => 'إضافة تسلسل',
            'Add Supplier' => 'إضافة مورد',
            'Add supplier tag' => 'إضافة وسم للمورد',
            'Add to gallery' => 'إضافة إلى المعرض',
            'Add year (YYYY)' => 'إضافة السنة (YYYY)',
            'Adding...' => 'جارٍ الإضافة...',
            'Additional notes...' => 'ملاحظات إضافية...',
            'Address' => 'العنوان',
            'Address not provided' => 'العنوان غير متوفر',
            'Address:' => 'العنوان:',
            'Admin Language' => 'لغة لوحة التحكم',
            '⚙️ Company Settings' => '⚙️ إعدادات الشركة',
            '⚡ Default settings' => '⚡ الإعدادات الافتراضية',
            'Advanced Product Creation' => 'إنشاء منتجات متقدم',
            'Advanced stock management' => 'إدارة مخزون متقدمة',
            'Advanced settings' => 'إعدادات متقدمة',
            'All categories' => 'كل الفئات',
            'All product types' => 'كل أنواع المنتجات',
            'All products' => 'كل المنتجات',
            'All products automatically sync with WooCommerce' => 'تتم مزامنة كل المنتجات تلقائيًا مع WooCommerce',
            'All statuses' => 'كل الحالات',
            'All suppliers' => 'كل الموردين',
            'Allow' => 'سماح',
            'Allow backorders?' => 'السماح بالطلبات المؤجلة؟',
            'Allow, notify customer' => 'سماح، مع إشعار العميل',
            'Already paid' => 'مدفوع بالفعل',
            'Amount' => 'المبلغ',
            'Amount must be greater than 0.' => 'يجب أن يكون المبلغ أكبر من 0.',
            'Amount:' => 'المبلغ:',
            'An error occurred' => 'حدث خطأ',
            'Annual' => 'سنوي',
            'Are you sure you want to delete this expense?' => 'هل أنت متأكد أنك تريد حذف هذا المصروف؟',
            'Are you sure you want to delete this payment?' => 'هل أنت متأكد أنك تريد حذف هذه الدفعة؟',
            'Attributes' => 'السمات',
            'Attributes & variations' => 'السمات والمتغيرات',
            'Auto-generated' => 'مولّد تلقائيًا',
            'Balance' => 'الرصيد',
            'Balance due' => 'الرصيد المستحق',
            'Bank fees' => 'رسوم بنكية',
            'Base cost price' => 'سعر التكلفة الأساسي',
            'Base regular price' => 'السعر العادي الأساسي',
            'Base sale price' => 'سعر التخفيض الأساسي',
            'Basic information' => 'معلومات أساسية',
            'BILLED FROM:' => 'مفوتر من:',
            'Bi-weekly (every 2 weeks)' => 'كل أسبوعين',
            'Bonuses' => 'مكافآت',
            'Buy now' => 'اشترِ الآن',
            'Cancel' => 'إلغاء',
            'Card' => 'بطاقة',
            'Cash' => 'نقدًا',
            'Categories' => 'الفئات',
            'Categories & tags' => 'الفئات والوسوم',
            'Category' => 'فئة',
            'Category created successfully!' => 'تم إنشاء الفئة بنجاح!',
            'Check' => 'شيك',
            'Choose' => 'اختر',
            'Choose an image' => 'اختر صورة',
            'Choose images' => 'اختر صورًا',
            'Choose files' => 'اختر ملفات',
            'City, Country' => 'المدينة، البلد',
            'Click to add' => 'انقر للإضافة',
            'Click to add files' => 'انقر لإضافة ملفات',
            'Click to upload' => 'انقر للرفع',
            'Close' => 'إغلاق',
            'Collapse' => 'طيّ',
            'Company name' => 'اسم الشركة',
            'Company Settings - Bizmart' => 'إعدادات الشركة - Bizmart',
            'Confirm Payment' => 'تأكيد الدفع',
            'Connection error' => 'خطأ في الاتصال',
            'Connection error during upload.' => 'خطأ في الاتصال أثناء الرفع.',
            'Contact' => 'الاتصال',
            'Controls Bizmart admin UI language.' => 'يتحكم في لغة واجهة Bizmart داخل لوحة التحكم.',
            'Cost price' => 'سعر التكلفة',
            'Create' => 'إنشاء',
            'Create Invoice' => 'إنشاء فاتورة',
            'Create product' => 'إنشاء منتج',
            'Create Supplier' => 'إنشاء مورد',
            'Created' => 'تم الإنشاء',
            '⏳ Creating...' => '⏳ جارٍ الإنشاء...',
            '⏳ Creating product...' => '⏳ جارٍ إنشاء المنتج...',
            'Creating...' => 'جارٍ الإنشاء...',
            'Currency used for all reports and invoices.' => 'العملة المستخدمة في كل التقارير والفواتير.',
            'Custom' => 'مخصص',
            'Custom description' => 'وصف مخصص',
            'Custom product' => 'منتج مخصص',
            'Daily' => 'يومي',
            'Dashboard' => 'لوحة التحكم',
            'Date' => 'التاريخ',
            'Date:' => 'التاريخ:',
            'Days' => 'أيام',
            'Default' => 'افتراضي',
            'Default currency' => 'العملة الافتراضية',
            'Delete' => 'حذف',
            'Delete permanently' => 'حذف نهائيًا',
            'Delete this invoice' => 'حذف هذه الفاتورة',
            'Delete this item' => 'حذف هذا العنصر',
            'Description' => 'الوصف',
            'Descriptive product name' => 'اسم منتج وصفي',
            'Digital' => 'رقمي',
            'Digital product' => 'منتج رقمي',
            'Digital/Downloadable product' => 'منتج رقمي/قابل للتنزيل',
            'Disable' => 'تعطيل',
            'Discount' => 'خصم',
            'Discount:' => 'الخصم:',
            'Display full address' => 'عرض العنوان الكامل',
            'Display logo on invoices' => 'عرض الشعار في الفواتير',
            'Display registration numbers' => 'عرض أرقام التسجيل',
            'Downloadable files' => 'ملفات قابلة للتنزيل',
            'Due' => 'مستحق',
            'Edit' => 'تعديل',
            'Edit in WooCommerce' => 'تعديل في WooCommerce',
            'Email' => 'البريد الإلكتروني',
            'Email:' => 'البريد الإلكتروني:',
            'Enable' => 'تفعيل',
            'Enable stock tracking' => 'تفعيل تتبع المخزون',
            'Error' => 'خطأ',
            'Expenses' => 'المصاريف',
            'Export data' => 'تصدير البيانات',
            'External' => 'خارجي',
            'External product' => 'منتج خارجي',
            'Filter' => 'تصفية',
            'Financial summary' => 'ملخص مالي',
            'Friday' => 'الجمعة',
            'From ' => 'من ',
            'Fuel' => 'وقود',
            'Full description' => 'الوصف الكامل',
            'Gas' => 'غاز',
            'Global balance' => 'الرصيد الإجمالي',
            'Gross profit' => 'الربح الإجمالي',
            'Gross salaries' => 'إجمالي الرواتب',
            'Grouped' => 'مجموعة',
            'Grouped product' => 'منتج مجمّع',
            'Height (cm)' => 'الارتفاع (سم)',
            'History' => 'السجل',
            'IBAN (Bank account)' => 'IBAN (الحساب البنكي)',
            'Image' => 'صورة',
            'Image gallery' => 'معرض الصور',
            'In stock' => 'متوفر',
            'Information' => 'معلومات',
            'Insufficient permissions' => 'صلاحيات غير كافية',
            'Insurance' => 'تأمين',
            'Internal Reference' => 'مرجع داخلي',
            'Internet' => 'إنترنت',
            'Interval' => 'الفاصل',
            'Inventory' => 'المخزون',
            'Invoice' => 'فاتورة',
            'Invoice #' => 'رقم الفاتورة',
            'Invoice created successfully! ID: ' => 'تم إنشاء الفاتورة بنجاح! المعرّف: ',
            'Invoice footer text' => 'نص تذييل الفاتورة',
            'Invoice Management System' => 'نظام إدارة الفواتير',
            'Invoice number format' => 'تنسيق رقم الفاتورة',
            'Invoice Preview' => 'معاينة الفاتورة',
            'Invoice updated successfully!' => 'تم تحديث الفاتورة بنجاح!',
            '✅ Invoice deleted successfully!' => '✅ تم حذف الفاتورة بنجاح!',
            '✅ Invoice permanently deleted' => '✅ تم حذف الفاتورة نهائيًا',
            '✅ Invoice restored successfully!' => '✅ تم استعادة الفاتورة بنجاح!',
            '✅ Payment created and status updated!' => '✅ تم إنشاء الدفعة وتحديث الحالة!',
            '✅ Payment of \'+ formatMoney(amount) +\' added successfully!' => '✅ تمت إضافة دفعة بقيمة \'+ formatMoney(amount) +\' بنجاح!',
            '✅ Product created successfully! ID: ' => '✅ تم إنشاء المنتج بنجاح! المعرّف: ',
            '✅ Supplier created successfully!' => '✅ تم إنشاء المورد بنجاح!',
            '❌ Auto-save failed. Please try again.' => '❌ فشل الحفظ التلقائي. يرجى المحاولة مرة أخرى.',
            '❌ Connection error' => '❌ خطأ في الاتصال',
            '❌ Connection error: ' => '❌ خطأ في الاتصال: ',
            '❌ Error: ' => '❌ خطأ: ',
            '❌ Load error: ' => '❌ خطأ تحميل: ',
            '❌ Network error while saving.' => '❌ خطأ شبكة أثناء الحفظ.',
            '❌ Network error: ' => '❌ خطأ شبكة: ',
            '❌ Please enter a valid amount.' => '❌ يرجى إدخال مبلغ صالح.',
            '❌ Request timeout' => '❌ انتهت مهلة الطلب',
            '❌ Request timed out (30s). The product may have been created anyway.' => '❌ انتهت مهلة الطلب (30 ثانية). قد يكون المنتج قد أُنشئ على أي حال.',
            '❌ Unable to auto-save the invoice.' => '❌ تعذر حفظ الفاتورة تلقائيًا.',
            '♻️ Restore this invoice?\n\nStock and balances will be adjusted.' => '♻️ استعادة هذه الفاتورة؟\n\nسيتم تعديل المخزون والأرصدة.',
            '⚠️ FINAL CONFIRMATION\n\nAre you absolutely sure you want to permanently delete this invoice?\n\nIt cannot be recovered.' => '⚠️ تأكيد نهائي\n\nهل أنت متأكد تمامًا أنك تريد حذف هذه الفاتورة نهائيًا؟\n\nلا يمكن استرجاعها.',
            '⚠️ WARNING: Permanently delete this invoice?\n\nThis action is IRREVERSIBLE.\nAll data (payments, items) will be deleted permanently.' => '⚠️ تحذير: حذف هذه الفاتورة نهائيًا؟\n\nهذا الإجراء لا رجعة فيه.\nسيتم حذف جميع البيانات (الدفعات، العناصر) نهائيًا.',
            'Invoices' => 'الفواتير',
            'Invoices:' => 'الفواتير:',
            'Issuer (Company)' => 'الجهة المُصدِرة (الشركة)',
            'Item' => 'عنصر',
            'Items / Products' => 'العناصر / المنتجات',
            'Last 30 days' => 'آخر 30 يومًا',
            'Last 7 days' => 'آخر 7 أيام',
            'Length (cm)' => 'الطول (سم)',
            'Linked products' => 'منتجات مرتبطة',
            'Loading...' => 'جارٍ التحميل...',
            'Logo' => 'الشعار',
            'Logo preview' => 'معاينة الشعار',
            'Main image' => 'الصورة الرئيسية',
            'Maintenance' => 'صيانة',
            'Manage stock' => 'إدارة المخزون',
            'Margin' => 'الهامش',
            'Margin %' => 'نسبة الهامش %',
            'Menu order' => 'ترتيب القائمة',
            'Method' => 'الطريقة',
            'Monday' => 'الاثنين',
            'Monthly' => 'شهري',
            'Months' => 'أشهر',
            'Must be unique' => 'يجب أن يكون فريدًا',
            'Name' => 'الاسم',
            'Name:' => 'الاسم:',
            'Network error' => 'خطأ في الشبكة',
            'Never' => 'أبدًا',
            'New category' => 'فئة جديدة',
            'New Invoice' => 'فاتورة جديدة',
            'New Supplier' => 'مورد جديد',
            'No' => 'لا',
            'None' => 'لا شيء',
            'Note' => 'ملاحظة',
            'Note:' => 'ملاحظة:',
            'Notes' => 'ملاحظات',
            'Office' => 'مكتب',
            'On backorder' => 'طلب مؤجل',
            'Order' => 'طلب',
            'Other' => 'أخرى',
            'Out of stock' => 'غير متوفر',
            'Overtime' => 'ساعات إضافية',
            'Paid' => 'مدفوع',
            'Partial' => 'جزئي',
            'Partially paid' => 'مدفوع جزئيًا',
            'Payment' => 'دفعة',
            'Payment Amount' => 'مبلغ الدفعة',
            'Payment deleted successfully' => 'تم حذف الدفعة بنجاح',
            'Payment history' => 'سجل الدفعات',
            'Payment method' => 'طريقة الدفع',
            'Payment mode' => 'نمط الدفع',
            'Payments' => 'الدفعات',
            'Phone' => 'الهاتف',
            'Phone:' => 'الهاتف:',
            'Please enter a category name' => 'يرجى إدخال اسم فئة',
            'Please enter a product name' => 'يرجى إدخال اسم المنتج',
            'Please enter the supplier name' => 'يرجى إدخال اسم المورد',
            'Please fill in all required fields' => 'يرجى تعبئة جميع الحقول المطلوبة',
            'Preview' => 'معاينة',
            'Preview & Print' => 'معاينة وطباعة',
            'Price' => 'السعر',
            'Print' => 'طباعة',
            'Private' => 'خاص',
            'Processing...' => 'جارٍ المعالجة...',
            'Product' => 'منتج',
            'Product description...' => 'وصف المنتج...',
            'Product image' => 'صورة المنتج',
            'Product images' => 'صور المنتج',
            'Product name' => 'اسم المنتج',
            'Product name is required' => 'اسم المنتج مطلوب',
            'Product settings' => 'إعدادات المنتج',
            'Product status' => 'حالة المنتج',
            'Products' => 'المنتجات',
            'Profit' => 'الربح',
            'Profit:' => 'الربح:',
            'Publish' => 'نشر',
            'Publish date' => 'تاريخ النشر',
            'Published' => 'منشور',
            'Purchase note' => 'ملاحظة الشراء',
            'Purchase price' => 'سعر الشراء',
            'Qty' => 'الكمية',
            'Quantity' => 'الكمية',
            'Quarterly' => 'ربع سنوي',
            'Quick actions' => 'إجراءات سريعة',
            'Quick Payment' => 'دفعة سريعة',
            'Quick Product Creation' => 'إنشاء منتج سريع',
            'Product created instantly!' => 'تم إنشاء المنتج فورًا!',
            'Product created successfully!' => 'تم إنشاء المنتج بنجاح!',
            'BizProducts ready — enhanced UI active' => 'BizProducts جاهز — الواجهة المحسّنة نشطة',
            'Real-time performance' => 'الأداء في الوقت الحقيقي',
            'Recent orders' => 'الطلبات الأخيرة',
            'Recently created products' => 'المنتجات المُنشأة حديثًا',
            'Recorded date' => 'التاريخ المسجل',
            'Reference' => 'مرجع',
            'Regular price' => 'السعر العادي',
            'Remaining' => 'المتبقي',
            'Remove' => 'إزالة',
            'Reset' => 'إعادة ضبط',
            'Restore' => 'استعادة',
            'Restore this invoice' => 'استعادة هذه الفاتورة',
            'Reviews' => 'المراجعات',
            'Sale price' => 'سعر التخفيض',
            'Sales' => 'المبيعات',
            'Saturday' => 'السبت',
            'Save' => 'حفظ',
            'Save & Close' => 'حفظ وإغلاق',
            'Save as draft' => 'حفظ كمسودة',
            'Save changes' => 'حفظ التغييرات',
            'Save draft' => 'حفظ مسودة',
            'Saving...' => 'جارٍ الحفظ...',
            'Search...' => 'بحث...',
            'Select a category' => 'اختر فئة',
            'Select a product' => 'اختر منتجًا',
            'Select a supplier...' => 'اختر موردًا...',
            'Select an image' => 'اختر صورة',
            'Select files' => 'اختر ملفات',
            'Select images' => 'اختر صورًا',
            'Select or upload a logo' => 'اختر أو ارفع شعارًا',
            'Select...' => 'اختر...',
            'Semiannual' => 'نصف سنوي',
            'Server connection error.' => 'خطأ اتصال بالخادم.',
            'Settings' => 'الإعدادات',
            'Settings saved successfully!' => 'تم حفظ الإعدادات بنجاح!',
            'Shipping' => 'الشحن',
            'Shipping & dimensions' => 'الشحن والأبعاد',
            'Shipping class' => 'فئة الشحن',
            'Shipping fees' => 'رسوم الشحن',
            'Short description' => 'وصف قصير',
            'Short description shown in lists...' => 'وصف قصير يظهر في القوائم...',
            'Show all' => 'عرض الكل',
            'Simple' => 'بسيط',
            'Simple product' => 'منتج بسيط',
            'SKU' => 'SKU',
            'Slogan' => 'الشعار/العبارة',
            'Social charges' => 'الاشتراكات الاجتماعية',
            'Social media' => 'وسائل التواصل الاجتماعي',
            'Software' => 'برمجيات',
            'Sold individually?' => 'يباع بشكل فردي؟',
            'Status' => 'الحالة',
            'Status:' => 'الحالة:',
            'Stock' => 'المخزون',
            'Stock quantity' => 'كمية المخزون',
            'Stock status' => 'حالة المخزون',
            'Subcategories (optional)' => 'فئات فرعية (اختياري)',
            'Subtotal' => 'المجموع الفرعي',
            'Subtotal:' => 'المجموع الفرعي:',
            'Summary' => 'ملخص',
            'Sunday' => 'الأحد',
            'Supplier' => 'مورد',
            'Supplier (optional)' => 'مورد (اختياري)',
            'Supplier Address' => 'عنوان المورد',
            'Supplier and amount are required' => 'المورد والمبلغ مطلوبان',
            'Supplier details' => 'تفاصيل المورد',
            'Supplier name is required' => 'اسم المورد مطلوب',
            'Supplier payments' => 'دفعات المورد',
            'Supplier Reference' => 'مرجع المورد',
            'Supplier: ' => 'المورد: ',
            'Suppliers' => 'الموردون',
            'Supplies' => 'لوازم',
            'Sync' => 'مزامنة',
            'Tags' => 'وسوم',
            'Tax' => 'ضريبة',
            'Tax:' => 'الضريبة:',
            'Taxes' => 'الضرائب',
            'Thank you for your trust.' => 'شكرًا لثقتكم.',
            'This month' => 'هذا الشهر',
            'This week' => 'هذا الأسبوع',
            'This year' => 'هذا العام',
            'Thursday' => 'الخميس',
            'Today\'s profit' => 'ربح اليوم',
            'Today\'s sales' => 'مبيعات اليوم',
            'Total' => 'الإجمالي',
            'Total amount' => 'إجمالي المبلغ',
            'Total billed' => 'إجمالي المفوتر',
            'Total paid' => 'إجمالي المدفوع',
            'Total unpaid' => 'إجمالي غير المدفوع',
            'Training' => 'تدريب',
            'Transfer' => 'تحويل',
            'Transport' => 'نقل',
            'Tuesday' => 'الثلاثاء',
            'Type' => 'النوع',
            'Unauthorized' => 'غير مصرح',
            'Unexpected' => 'غير متوقع',
            'Unique reference' => 'مرجع فريد',
            'Unit Price' => 'سعر الوحدة',
            'Unknown error' => 'خطأ غير معروف',
            'Unknown error.' => 'خطأ غير معروف.',
            'Unknown supplier' => 'مورد غير معروف',
            'Unlimited' => 'غير محدود',
            'Unpaid' => 'غير مدفوع',
            'Update' => 'تحديث',
            'Upload / Choose a logo' => 'رفع / اختيار شعار',
            'Upload error: ' => 'خطأ رفع: ',
            'Uploading ' => 'جارٍ الرفع ',
            'Upsells' => 'ترقيات/مبيعات إضافية',
            'Use these files' => 'استخدم هذه الملفات',
            'Use this image' => 'استخدم هذه الصورة',
            'Used for banking details on invoices.' => 'تستخدم للتفاصيل البنكية في الفواتير.',
            'Values' => 'القيم',
            'Variable' => 'متغير',
            'Variable product' => 'منتج متغير',
            'Variation' => 'متغير',
            'Variation SKU' => 'SKU المتغير',
            'Variations' => 'المتغيرات',
            'Vehicle maintenance' => 'صيانة المركبات',
            'View' => 'عرض',
            'View details' => 'عرض التفاصيل',
            'View invoices' => 'عرض الفواتير',
            'View list' => 'عرض القائمة',
            'View product' => 'عرض المنتج',
            'Warehouse' => 'مستودع',
            'Water' => 'ماء',
            'Website' => 'الموقع الإلكتروني',
            'Wednesday' => 'الأربعاء',
            'Weekly' => 'أسبوعي',
            'Weeks' => 'أسابيع',
            'Weight (kg)' => 'الوزن (كغ)',
            'Width (cm)' => 'العرض (سم)',
            'Workshop' => 'ورشة',
            'Years' => 'سنوات',
            'Yes' => 'نعم',
            'Your company name' => 'اسم شركتك',

            // --- Bulk MSA coverage (dictionary fallback) ---
            ' [DRAFT]' => ' [مسودة]',
            '[DRAFT]' => '[مسودة]',
            'DRAFT' => 'مسودة',
            ' (Applied to: ' => ' (يُطبَّق على: ',
            ' (Global payment)' => ' (دفعة شاملة)',
            '(Global payment)' => 'دفعة شاملة',
            'to' => 'إلى',
            ' to ' => ' إلى ',
            '{YYMMDD}' => '{YYMMDD}',
            '{YYYY}' => '{YYYY}',
            '+ Add' => '+ إضافة',
            '+ Create a new attribute' => '+ إنشاء سمة جديدة',
            '-- Choose an existing attribute --' => '-- اختر سمة موجودة --',
            'Choose an existing attribute' => 'اختر سمة موجودة',
            'Choose a Variation' => 'اختر متغيرًا',
            'Choose files' => 'اختر ملفات',
            'Media uploader is not available. Please refresh the page.' => 'أداة رفع الوسائط غير متاحة. يرجى تحديث الصفحة.',
            'Missing AJAX URL (admin-ajax.php).' => 'عنوان AJAX مفقود (admin-ajax.php).',
            'Missing security token (nonce). Please refresh the page.' => 'رمز الأمان (nonce) مفقود. يرجى تحديث الصفحة.',
            'Invalid nonce' => 'رمز nonce غير صالح',
            'Request timeout' => 'انتهت مهلة الطلب',
            'Request error' => 'خطأ في الطلب',
            'Server error' => 'خطأ في الخادم',
            'Server error (500).' => 'خطأ في الخادم (500).',
            'Undefined' => 'غير معرّف',
            'Unexpected' => 'غير متوقع',

            // More invoice/payment strings
            'Invoice #' => 'رقم الفاتورة',
            'Invoice #:' => 'رقم الفاتورة:',
            'Invoice is already paid' => 'الفاتورة مدفوعة بالفعل',
            'Payment recorded successfully' => 'تم تسجيل الدفعة بنجاح',
            'Payment rate' => 'معدل الدفع',
            'Payment rate:' => 'معدل الدفع:',
            'Paid rate' => 'معدل السداد',
            'Remaining after payment:' => 'المتبقي بعد الدفع:',
            'Delete this payment' => 'حذف هذه الدفعة',
            'Delete payment' => 'حذف الدفعة',
            'Delete this expense' => 'حذف هذا المصروف',
            'Edit payment' => 'تعديل الدفعة',
            'Edit invoice' => 'تعديل الفاتورة',
            'Edit supplier' => 'تعديل المورد',
            'View payments' => 'عرض الدفعات',
            'Payment date' => 'تاريخ الدفعة',
            'Payment Date' => 'تاريخ الدفعة',
            'Payment notes' => 'ملاحظات الدفعة',
            'Payment Notes' => 'ملاحظات الدفعة',
            'Payment Method' => 'طريقة الدفع',
            'Payment Mode' => 'نمط الدفع',
            'Global payment' => 'دفعة شاملة',

            // Supplier strings
            'Supplier' => 'مورد',
            'Supplier:' => 'المورد:',
            'Suppliers' => 'الموردون',
            'All suppliers' => 'كل الموردين',
            'Active suppliers:' => 'الموردون النشطون:',
            'Supplier name' => 'اسم المورد',
            'Supplier Name' => 'اسم المورد',
            'Supplier phone' => 'هاتف المورد',
            'Supplier email' => 'بريد المورد الإلكتروني',
            'Supplier address' => 'عنوان المورد',
            'Unable to delete: this supplier has linked invoices.' => 'لا يمكن الحذف: هذا المورد لديه فواتير مرتبطة.',
            'Supplier and amount are required' => 'المورد والمبلغ مطلوبان',
            'Please select a supplier...' => 'اختر موردًا...',
            'Please select a supplier and enter a valid amount.' => 'يرجى اختيار مورد وإدخال مبلغ صالح.',

            // Misc common labels
            'None' => 'لا شيء',
            'Other' => 'أخرى',
            'Notes' => 'ملاحظات',
            'Note: ' => 'ملاحظة: ',
            'Reference...' => 'مرجع...',
            'Search by order number...' => 'البحث برقم الطلب...',
            'Show all' => 'عرض الكل',
            'Total:' => 'الإجمالي:',
            'Subtotal:' => 'المجموع الفرعي:',
            'Discount:' => 'الخصم:',
            'Tax:' => 'الضريبة:',

            // Example helpers
            'e.g. Buy on Amazon' => 'مثال: اشترِ على أمازون',
            'e.g. Color, Size' => 'مثال: اللون، المقاس',
            'e.g. INV-2023-001' => 'مثال: INV-2023-001',
            'e.g. Red, Blue, Green (comma-separated)' => 'مثال: أحمر، أزرق، أخضر (مفصولة بفواصل)',
            'Example:' => 'مثال:',
            'Example Supplier' => 'مورد مثال',
            'Example product 1' => 'منتج مثال 1',
            'Example product 2' => 'منتج مثال 2',

            // --- Missing keys batch (MSA) ---
            '✅ Payment of \' + formatMoney(amount) + \' added successfully!' => '✅ تمت إضافة دفعة بقيمة \' + formatMoney(amount) + \' بنجاح!',
            '7 days' => '7 أيام',
            '30 days' => '30 يومًا',
            'Attachments (invoice PDF, Excel, etc.)' => 'المرفقات (PDF الفاتورة، Excel، إلخ)',
            'Attribute name' => 'اسم السمة',
            'Attribute name (e.g. Color, Size)' => 'اسم السمة (مثال: اللون، المقاس)',
            'Attribute name (e.g., Color, Size)' => 'اسم السمة (مثال: اللون، المقاس)',
            'Attribute values' => 'قيم السمات',
            'Auto payment - marked as paid' => 'دفعة تلقائية - تم تعليمها كمدفوعة',
            'Automatically add to Expenses' => 'الإضافة تلقائيًا إلى المصاريف',
            'Automatically create a similar expense based on the selected frequency. You can customize the interval and preview the next occurrence.' => 'إنشاء مصروف مشابه تلقائيًا وفقًا للتكرار المحدد. يمكنك تخصيص الفاصل ومعاينة الموعد القادم.',
            'Avg. margin per item:' => 'متوسط الهامش لكل عنصر:',
            'Base pricing' => 'التسعير الأساسي',
            'Best performing products by sales volume' => 'أفضل المنتجات أداءً حسب حجم المبيعات',
            'Bundle description...' => 'وصف الحزمة...',
            'Bundle/kit name' => 'اسم الحزمة/الطقم',
            'Bundles/sets of products' => 'حزم/مجموعات منتجات',
            'Button text' => 'نص الزر',
            'Click a row to target a payment.' => 'انقر على سطر لاستهداف دفعة.',
            'Click the buttons above to build your invoice number format.' => 'انقر على الأزرار أعلاه لبناء تنسيق رقم الفاتورة.',
            'Color: Red, Size: M' => 'اللون: أحمر، المقاس: M',
            'Color|Red, Size|M' => 'اللون|أحمر، المقاس|M',
            'Complete overview of your sales, profit, and performance' => 'نظرة شاملة على مبيعاتك وأرباحك وأدائك',
            'Confirm this invoice is fully paid? This updates the status, but you must save the invoice to apply the change.' => 'تأكيد أن هذه الفاتورة مدفوعة بالكامل؟ سيؤدي ذلك إلى تحديث الحالة، لكن يجب حفظ الفاتورة لتطبيق التغيير.',
            'Confirm this payment of \' + formatMoney(amount) + \'?\nIt will be allocated across unpaid invoices (FIFO).' => 'هل تؤكد هذه الدفعة بقيمة \' + formatMoney(amount) + \'؟\nسيتم توزيعها على الفواتير غير المدفوعة (الأقدم أولاً).',
            'Connected to WooCommerce' => 'متصل بـ WooCommerce',
            'Connection error while saving.' => 'خطأ في الاتصال أثناء الحفظ.',
            'Consulting' => 'استشارات',
            'Create a grouped product that contains multiple simple products' => 'إنشاء منتج مجمّع يحتوي على عدة منتجات بسيطة',
            'Create a new attribute' => 'إنشاء سمة جديدة',
            'Create a New Invoice' => 'إنشاء فاتورة جديدة',
            'Create a new supplier' => 'إنشاء مورد جديد',
            'Create complete products with all WooCommerce features' => 'إنشاء منتجات كاملة مع جميع ميزات WooCommerce',
            'Create digital product' => 'إنشاء منتج رقمي',
            'Create external product' => 'إنشاء منتج خارجي',
            'Create grouped product' => 'إنشاء منتج مجمّع',
            'Create New Product' => 'إنشاء منتج جديد',
            'Create variable product' => 'إنشاء منتج متغير',
            'Cross-sells' => 'منتجات مقترحة (Cross-sells)',
            'Customize subcategories for each expense category. These options will appear when creating a new expense.' => 'تخصيص الفئات الفرعية لكل فئة مصروف. ستظهر هذه الخيارات عند إنشاء مصروف جديد.',
            'Data export (feature to be implemented)' => 'تصدير البيانات (ميزة قيد التطوير)',
            'Day of month' => 'يوم من الشهر',
            'Day of week' => 'يوم من الأسبوع',
            'Days until link expires' => 'عدد الأيام حتى انتهاء الرابط',
            'Decimal value detected. Round to the nearest integer to continue using +/- buttons?' => 'تم اكتشاف قيمة عشرية. قرّب إلى أقرب عدد صحيح لمتابعة استخدام أزرار +/-؟',
            'Delete this attachment?' => 'حذف هذا المرفق؟',
            'Delete this invoice item?' => 'حذف عنصر الفاتورة هذا؟',
            'Delete this payment?' => 'حذف هذه الدفعة؟',
            'Delete this product line?' => 'حذف سطر المنتج هذا؟',
            'Delete this subcategory?' => 'حذف هذه الفئة الفرعية؟',
            'Delete this supplier?' => 'حذف هذا المورد؟',
            'Detailed description...' => 'وصف تفصيلي...',
            'Detailed product description...' => 'وصف منتج تفصيلي...',
            'Digital product description...' => 'وصف المنتج الرقمي...',
            'Digital product name' => 'اسم المنتج الرقمي',
            'Digital products' => 'منتجات رقمية',
            'DIGITAL-SKU' => 'DIGITAL-SKU',
            'Do you really want to delete this quick payment?' => 'هل تريد فعلاً حذف هذه الدفعة السريعة؟',
            'Document generated by Bizmart' => 'مستند تم إنشاؤه بواسطة Bizmart',
            'Download limit' => 'حد التنزيل',
            'eBooks, music, software' => 'كتب إلكترونية، موسيقى، برمجيات',
            'Edit expense' => 'تعديل المصروف',
            'Edit Invoice #' => 'تعديل رقم الفاتورة',
            'Edit Payment' => 'تعديل الدفعة',
            'Edit product' => 'تعديل المنتج',
            'Electricity' => 'كهرباء',
            'End:' => 'النهاية:',
            'Error creating category' => 'خطأ أثناء إنشاء الفئة',
            'Error loading invoice' => 'خطأ أثناء تحميل الفاتورة',
            'Error loading invoice: ' => 'خطأ أثناء تحميل الفاتورة: ',
            'Error loading payment' => 'خطأ أثناء تحميل الدفعة',
            'Error loading the form' => 'خطأ أثناء تحميل النموذج',
            'Error saving payment: ' => 'خطأ أثناء حفظ الدفعة: ',
            'Error while creating' => 'خطأ أثناء الإنشاء',
            'Error while deleting' => 'خطأ أثناء الحذف',
            'Error while loading.' => 'خطأ أثناء التحميل.',
            'Error: ' => 'خطأ: ',
            'Events' => 'فعاليات',
            'Example: INV-2025-00042' => 'مثال: INV-2025-00042',
            'Expense added successfully' => 'تمت إضافة المصروف بنجاح',
            'Expense updated successfully' => 'تم تحديث المصروف بنجاح',
            'Expiry (days)' => 'مدة الانتهاء (بالأيام)',
            'External product description...' => 'وصف المنتج الخارجي...',
            'External product name' => 'اسم المنتج الخارجي',
            'External/Affiliate product' => 'منتج خارجي/تابع',
            'EXT-SKU' => 'EXT-SKU',
            'file(s) attached. Click to re-select.' => 'ملف/ملفات مرفقة. انقر لإعادة الاختيار.',
            'File/eBook name' => 'اسم الملف/الكتاب الإلكتروني',
            'Financial history' => 'السجل المالي',
            'Financial overview' => 'نظرة مالية عامة',
            'Format: Attribute: Value, Attribute: Value' => 'التنسيق: سمة: قيمة، سمة: قيمة',
            'Free payment' => 'دفعة مجانية',
            'Frequency' => 'التكرار',
            'Frequently bought together' => 'يُشترى معًا كثيرًا',
            'Full balance' => 'الرصيد الكامل',
            'Full description...' => 'وصف كامل...',
            'Full product description...' => 'وصف كامل للمنتج...',
            'Full supplier invoice management with financial synchronization' => 'إدارة كاملة لفواتير المورد مع مزامنة مالية',
            'Full supplier management and financial synchronization' => 'إدارة كاملة للمورد ومزامنة مالية',
            'Generate automatically' => 'توليد تلقائيًا',
            'Global balance:' => 'الرصيد الإجمالي:',
            'Global payment - %s %s' => 'دفعة شاملة - %s %s',
            'Global payment (FIFO)' => 'دفعة شاملة (الأقدم أولاً)',
            'Group image' => 'صورة المجموعة',
            'Group name' => 'اسم المجموعة',
            'Group SKU' => 'SKU المجموعة',
            'GROUP-SKU' => 'GROUP-SKU',
            'Images & galleries' => 'الصور والمعارض',
            'Invoice ' => 'فاتورة ',
            'Invoice #%d created - Amount: %s %s' => 'تم إنشاء الفاتورة #%d - المبلغ: %s %s',
            'Invoice #%d finalized in background - Amount: %s %s' => 'تم إنهاء الفاتورة #%d في الخلفية - المبلغ: %s %s',
            'Invoice #%d finalized in background - New amount: %s %s' => 'تم إنهاء الفاتورة #%d في الخلفية - المبلغ الجديد: %s %s',
            'Invoice #%d moved to trash (recoverable) - Amount: %s %s - Stock restored' => 'تم نقل الفاتورة #%d إلى سلة المحذوفات (قابلة للاستعادة) - المبلغ: %s %s - تم استعادة المخزون',
            'Invoice #%d permanently deleted - Amount: %s %s' => 'تم حذف الفاتورة #%d نهائيًا - المبلغ: %s %s',
            'Invoice #%d restored - Amount: %s %s - Stock adjusted' => 'تمت استعادة الفاتورة #%d - المبلغ: %s %s - تم تعديل المخزون',
            'Invoice #%d transferred (added) - Amount: %s %s' => 'تم تحويل الفاتورة #%d (إضافة) - المبلغ: %s %s',
            'Invoice #%d transferred (removed) - Amount: %s %s' => 'تم تحويل الفاتورة #%d (إزالة) - المبلغ: %s %s',
            'Invoice #%d updated - New amount: %s %s' => 'تم تحديث الفاتورة #%d - المبلغ الجديد: %s %s',
            'Invoice not found' => 'الفاتورة غير موجودة',
            'Key metrics' => 'مؤشرات رئيسية',
            'Last purchase: ' => 'آخر شراء: ',
            'Last sale: ' => 'آخر بيع: ',
            'Latest invoices' => 'أحدث الفواتير',
            'Latest transactions sorted by amount' => 'أحدث المعاملات مرتبة حسب المبلغ',
            'Legal status' => 'الوضع القانوني',
            'Line SKU' => 'SKU للسطر',
            'Load error: ' => 'خطأ تحميل: ',
            'Loading data...' => 'جارٍ تحميل البيانات...',
            'Loading form...' => 'جارٍ تحميل النموذج...',
            'Loading history...' => 'جارٍ تحميل السجل...',
            'Loading invoices...' => 'جارٍ تحميل الفواتير...',
            'Loading values...' => 'جارٍ تحميل القيم...',
            'Loading variations...' => 'جارٍ تحميل المتغيرات...',
            'Margin & Profit Calculator' => 'حاسبة الهامش والربح',
            'Margin percentage:' => 'نسبة الهامش:',
            'Max downloads per customer' => 'أقصى عدد تنزيلات لكل عميل',
            'Message after purchase...' => 'رسالة بعد الشراء...',
            'Method: ' => 'الطريقة: ',
            'Misc' => 'متفرقات',
            'Missing price' => 'سعر مفقود',
            'My Company' => 'شركتي',
            'Net profit' => 'الربح الصافي',
            'Net profit calculated today (sales - costs)' => 'الربح الصافي المحسوب اليوم (المبيعات - التكاليف)',
            'New Global Payment' => 'دفعة شاملة جديدة',
            'Next occurrence:' => 'الموعد القادم:',
            'No additional notes.' => 'لا توجد ملاحظات إضافية.',
            'No expenses recorded for this period.' => 'لا توجد مصاريف مسجلة لهذه الفترة.',
            'No history found' => 'لم يتم العثور على سجل',
            'No invoices found' => 'لم يتم العثور على فواتير',
            'No payments found' => 'لم يتم العثور على دفعات',
            'No payments recorded' => 'لا توجد دفعات مسجلة',
            'No payments recorded yet.' => 'لا توجد دفعات مسجلة بعد.',
            'No payments recorded.' => 'لا توجد دفعات مسجلة.',
            'No SKU' => 'لا يوجد SKU',
            'No suppliers found.' => 'لم يتم العثور على موردين.',
            'No unpaid invoices for this supplier.' => 'لا توجد فواتير غير مدفوعة لهذا المورد.',
            'No variations found for this product' => 'لم يتم العثور على متغيرات لهذا المنتج',
            'Not set' => 'غير مُعيّن',
            'Online advertising' => 'إعلانات عبر الإنترنت',
            'Operational expense management' => 'إدارة المصاريف التشغيلية',
            'Or create a new attribute' => 'أو أنشئ سمة جديدة',
            'Orders:' => 'الطلبات:',
            'Pack description...' => 'وصف الحزمة...',
            'Pack/kit name' => 'اسم الحزمة/الطقم',
            'Packaging' => 'تغليف',
            'Parent SKU' => 'SKU الأصل',
            'Parking' => 'مواقف',
            'Payment #' => 'رقم الدفعة',
            'Payment #%d deleted - Amount: %s %s' => 'تم حذف الدفعة #%d - المبلغ: %s %s',
            'Payment #%d updated - Difference: %s %s' => 'تم تحديث الدفعة #%d - الفرق: %s %s',
            'Payment for ' => 'دفعة لـ ',
            'Payment received for invoice #%d - Amount: %s %s - Method: %s' => 'تم استلام دفعة للفاتورة #%d - المبلغ: %s %s - الطريقة: %s',
            'payment(s)' => 'دفعة/دفعات',
            'Period:' => 'الفترة:',
            'Please add at least one downloadable file' => 'يرجى إضافة ملف واحد قابل للتنزيل على الأقل',
            'Please add at least one item' => 'يرجى إضافة عنصر واحد على الأقل',
            'Please create at least one variation' => 'يرجى إنشاء متغير واحد على الأقل',
            'Please define at least one attribute' => 'يرجى تعريف سمة واحدة على الأقل',
            'Please define attributes first' => 'يرجى تعريف السمات أولاً',
            'Please define attributes for variations first' => 'يرجى تعريف سمات المتغيرات أولاً',
            'Please enter a record date' => 'يرجى إدخال تاريخ التسجيل',
            'Please fill all fields correctly.' => 'يرجى تعبئة جميع الحقول بشكل صحيح.',
            'Please fill in the group name and SKU' => 'يرجى إدخال اسم المجموعة وSKU',
            'Please fill in the product name and SKU' => 'يرجى إدخال اسم المنتج وSKU',
            'Please save the invoice as a draft first.' => 'يرجى حفظ الفاتورة كمسودة أولاً.',
            'Please select at least one product to include in the group' => 'يرجى اختيار منتج واحد على الأقل لإدراجِه في المجموعة',
            'Preview Test Invoice' => 'معاينة فاتورة تجريبية',
            'Product ID required' => 'معرّف المنتج مطلوب',
            'Product line name' => 'اسم سطر المنتج',
            'Product not found' => 'المنتج غير موجود',
            'Product sold on another site (Amazon, etc.)' => 'منتج يُباع على موقع آخر (أمازون، إلخ)',
            'Product types' => 'أنواع المنتجات',
            'Product updated successfully (status: %s)' => 'تم تحديث المنتج بنجاح (الحالة: %s)',
            'Product URL' => 'رابط المنتج',
            'products affected' => 'منتجات متأثرة',
            'Products generating the highest profit' => 'المنتجات التي تحقق أعلى ربح',
            'Products missing purchase price' => 'منتجات تفتقد سعر الشراء',
            'Products sold on other sites' => 'منتجات تُباع على مواقع أخرى',
            'Products to include' => 'منتجات لإدراجها',
            'Products with options (size, color)' => 'منتجات بخيارات (المقاس، اللون)',
            'Publish this product (change from draft to published)?' => 'نشر هذا المنتج (تغيير من مسودة إلى منشور)؟',
            'Purchase cost for this variation' => 'تكلفة الشراء لهذا المتغير',
            'Purchase cost used for margin calculation.' => 'تكلفة الشراء المستخدمة في حساب الهامش.',
            'Purchase limit' => 'حد الشراء',
            'Purchase: ' => 'شراء: ',
            'Quick tips' => 'نصائح سريعة',
            'Range name' => 'اسم النطاق',
            'Range SKU' => 'SKU النطاق',
            'RC (Commercial Register)' => 'RC (السجل التجاري)',
            'Recent history' => 'سجل حديث',
            'Recommended: 600x600 pixels' => 'الموصى به: 600×600 بكسل',
            'Recurring expense' => 'مصروف متكرر',
            'Reference, notes...' => 'مرجع، ملاحظات...',
            'Remove this variation' => 'إزالة هذا المتغير',
            'Sale price (promo)' => 'سعر التخفيض (عرض)',
            'Sale: ' => 'بيع: ',
            'Sales & profit trend' => 'اتجاه المبيعات والأرباح',
            'Same as date' => 'نفس التاريخ',
            'Save error' => 'خطأ حفظ',
            'Save error: ' => 'خطأ حفظ: ',
            'Saving & paying...' => 'جارٍ الحفظ والدفع...',
            'Search for a product...' => 'ابحث عن منتج...',
            'Search or choose a product...' => 'ابحث عن منتج أو اختره...',
            'Select a supplier to view invoices.' => 'اختر موردًا لعرض الفواتير.',
            'Select an existing attribute' => 'اختر سمة موجودة',
            'Select an invoice if you want to target a specific due amount.' => 'اختر فاتورة إذا كنت تريد استهداف مبلغ مستحق محدد.',
            'Select the simple products to include in this group' => 'اختر المنتجات البسيطة لإدراجها في هذه المجموعة',
            'SEO/SEM' => 'تحسين محركات البحث/التسويق عبر محركات البحث',
            'Separate values with commas or add them one by one' => 'افصل القيم بفواصل أو أضفها واحدة تلو الأخرى',
            'Server connection error: ' => 'خطأ اتصال بالخادم: ',
            'Set purchase price' => 'تعيين سعر الشراء',
            'Settle Balance' => 'تسوية الرصيد',
            'Shipping:' => 'الشحن:',
            'Shop' => 'المتجر',
            'Short description...' => 'وصف قصير...',
            'Similar higher-quality products' => 'منتجات مشابهة بجودة أعلى',
            'Since the beginning' => 'منذ البداية',
            'SKUs separated by commas' => 'SKUs مفصولة بفواصل',
            'Standard physical or digital items' => 'عناصر قياسية مادية أو رقمية',
            'Start rule (custom)' => 'قاعدة البداية (مخصص)',
            'Status: ' => 'الحالة: ',
            'Stock value' => 'قيمة المخزون',
            'Stock value / Total products' => 'قيمة المخزون / إجمالي المنتجات',
            'Subcategory name:' => 'اسم الفئة الفرعية:',
            'Subscriptions' => 'اشتراكات',
            'Supplier credit:' => 'رصيد المورد:',
            'Supplier invoice date' => 'تاريخ فاتورة المورد',
            'Supplier invoices' => 'فواتير المورد',
            'Supported features:' => 'الميزات المدعومة:',
            'Tax (9%)' => 'ضريبة (9%)',
            'These products have no cost set, preventing accurate profit calculation' => 'لا توجد تكلفة محددة لهذه المنتجات، مما يمنع حساب الربح بدقة',
            'This invoice is not fully paid. Create a payment for the remaining amount? (\' + remainingLabel + \')' => 'هذه الفاتورة غير مدفوعة بالكامل. إنشاء دفعة للمبلغ المتبقي؟ (\' + remainingLabel + \')',
            'This logo will appear on all generated invoices.' => 'سيظهر هذا الشعار على جميع الفواتير المُولدة.',
            'This payment will settle invoices from oldest to newest.' => 'ستقوم هذه الدفعة بتسوية الفواتير من الأقدم إلى الأحدث.',
            'Today\'s profit' => 'ربح اليوم',
            'Today\'s sales' => 'مبيعات اليوم',
            'Top 5 best sellers' => 'أفضل 5 مبيعات',
            'Top 5 most profitable' => 'أكثر 5 ربحًا',
            'Total billed:' => 'إجمالي المفوتر:',
            'Total credit:' => 'إجمالي الدائن:',
            'Total debt:' => 'إجمالي المدين:',
            'TOTAL DUE' => 'إجمالي المستحق',
            'Total expenses (period)' => 'إجمالي المصاريف (الفترة)',
            'Total invoices' => 'إجمالي الفواتير',
            'Total margin:' => 'إجمالي الهامش:',
            'Total paid:' => 'إجمالي المدفوع:',
            'Total products' => 'إجمالي المنتجات',
            'Total purchase cost:' => 'إجمالي تكلفة الشراء:',
            'Total sale value:' => 'إجمالي قيمة المبيعات:',
            'Total sales made today' => 'إجمالي المبيعات اليوم',
            'Total stock value based on purchase prices / Total number of products' => 'إجمالي قيمة المخزون بناءً على أسعار الشراء / إجمالي عدد المنتجات',
            'Total unpaid:' => 'إجمالي غير المدفوع:',
            'unpaid invoice(s)' => 'فاتورة/فواتير غير مدفوعة',
            'Unpaid invoices:' => 'فواتير غير مدفوعة:',
            'Used for variations' => 'تُستخدم للمتغيرات',
            'Valid date and amount are required.' => 'تاريخ ومبلغ صالحان مطلوبان.',
            'Virtual product (no shipping)' => 'منتج افتراضي (بدون شحن)',
            'Virtual products with downloadable files' => 'منتجات افتراضية بملفات قابلة للتنزيل',
            'Visible on product page' => 'ظاهر في صفحة المنتج',
            'Visible on the product page' => 'ظاهر على صفحة المنتج',
            '🏢 Rent' => '🏢 إيجار',
            '🏢 Rent\n👥 Salaries\n💡 Utilities\n📢 Marketing\n🚚 Delivery\n🛠️ Tools & Services\n📦 Other' => '🏢 إيجار\n👥 رواتب\n💡 مرافق\n📢 تسويق\n🚚 توصيل\n🛠️ أدوات وخدمات\n📦 أخرى',
            '👥 Salaries' => '👥 رواتب',
            '💡 Utilities' => '💡 مرافق',
            '💾 Saving in background...' => '💾 جارٍ الحفظ في الخلفية...',
            '📢 Marketing' => '📢 تسويق',
            '📦 Other' => '📦 أخرى',
            '🚚 Delivery' => '🚚 توصيل',
            '🛠️ Tools & Services' => '🛠️ أدوات وخدمات',

            // Remaining scan variants (apostrophe/formatting differences)
            'No end date set — recurrence is open and will continue until manually stopped' => 'لا يوجد تاريخ نهاية — التكرار مفتوح وسيستمر حتى يتم إيقافه يدويًا',
            "Today's sales" => 'مبيعات اليوم',
            "Today's profit" => 'ربح اليوم',
            "✅ Payment of ' + formatMoney(amount) + ' added successfully!" => "✅ تمت إضافة دفعة بقيمة ' + formatMoney(amount) + ' بنجاح!",
            "Confirm this payment of ' + formatMoney(amount) + '?\nIt will be allocated across unpaid invoices (FIFO)." => "هل تؤكد هذه الدفعة بقيمة ' + formatMoney(amount) + '؟\nسيتم توزيعها على الفواتير غير المدفوعة (الأقدم أولاً).",
            "This invoice is not fully paid. Create a payment for the remaining amount? (' + remainingLabel + ')" => "هذه الفاتورة غير مدفوعة بالكامل. إنشاء دفعة للمبلغ المتبقي؟ (' + remainingLabel + ')",

            // Misc emoji headings used across pages
            '🎉 Invoice fully paid!' => '🎉 تم سداد الفاتورة بالكامل!',
            '👁️ Preview test invoice' => '👁️ معاينة فاتورة تجريبية',
            '💾 Save all changes' => '💾 حفظ كل التغييرات',
            '🏢 Company Identity' => '🏢 هوية الشركة',
            '📍 Contact' => '📍 الاتصال',
            '📊 Expense subcategories' => '📊 فئات فرعية للمصروفات',
            '📋 Registration numbers (Legal)' => '📋 أرقام التسجيل (قانونية)',
            '🔍 Search by order number...' => '🔍 البحث برقم الطلب...',
            '🗑️ Deleted' => '🗑️ محذوفة',
            '🗑️ Move this invoice to the trash?\n\nYou can restore it later from the "Deleted" tab.' => '🗑️ نقل هذه الفاتورة إلى سلة المحذوفات؟\n\nيمكنك استعادتها لاحقًا من تبويب "محذوفة".',
        ];
    }
}
