(function($){
    $(function(){
        if (typeof window.intlTelInput === 'undefined') return;

        var utils = (BizmartPhoneData && BizmartPhoneData.utilsScript) ? BizmartPhoneData.utilsScript : null;

        function initPhoneInput(selector, initialCountry, initialNumber) {
            var input = document.querySelector(selector);
            if (!input) return null;
            var iti = window.intlTelInput(input, {
                initialCountry: initialCountry || 'auto',
                separateDialCode: true,
                utilsScript: utils || '',
                autoHideDialCode: false,
                autoPlaceholder: 'aggressive',
                nationalMode: false
            });

            if (initialNumber) {
                try { iti.setNumber(initialNumber); } catch(e){}
            }
            return iti;
        }

        var companyPhoneIti = initPhoneInput('input[name="biz_company_phone"]', BizmartPhoneData.initialCountry || '', BizmartPhoneData.phone || '');
        var whatsappIti = initPhoneInput('input[name="biz_company_whatsapp"]', BizmartPhoneData.initialCountry || '', BizmartPhoneData.whatsapp || '');

        // Sync Country Dropdown with Phone Input
        $('select[name="biz_company_country"]').on('change', function() {
            var countryCode = $(this).val();
            if (countryCode) {
                if (companyPhoneIti) companyPhoneIti.setCountry(countryCode);
                if (whatsappIti) whatsappIti.setCountry(countryCode);
            }
        });

        // On submit, replace visible value with E.164 from intl-tel-input
        var form = document.getElementById('biz-modern-form');
        if (form) {
            form.addEventListener('submit', function(e){
                var valid = true;
                var firstInvalidMsg = '';

                function validateAndSet(iti, inputName) {
                    if (!iti) return true;
                    var input = document.querySelector('input[name="' + inputName + '"]');
                    if (!input) return true;
                    var val = input.value.trim();
                    if (!val) { return true; } // empty is allowed
                    if (iti.isValidNumber()) {
                        try { input.value = iti.getNumber(); } catch(err) {}
                        return true;
                    }
                    // invalid
                    valid = false;
                    firstInvalidMsg = firstInvalidMsg || (window.BizmartI18n && BizmartI18n.ar && BizmartI18n.ar['Invalid phone number'] ? BizmartI18n.ar['Invalid phone number'] : 'Invalid phone number');
                    return false;
                }

                validateAndSet(companyPhoneIti, 'biz_company_phone');
                validateAndSet(whatsappIti, 'biz_company_whatsapp');

                if (!valid) {
                    e.preventDefault();
                    alert(firstInvalidMsg);
                    return false;
                }

                return true;
            }, false);
        }

    });
})(jQuery);